<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Bank extends Model
{
    protected $table = 'banks';
    
    protected $fillable = [
        'country',
        'country_code',
        'payout_type',
        'bank_name',
        'currency_code',
    ];
    
    /**
     * Get unique countries
     */
    public static function getCountries()
    {
        return self::select('country', 'country_code')
            ->distinct()
            ->orderBy('country')
            ->get();
    }
    
    /**
     * Get banks by country and payout type
     */
    public static function getBanksByCountryAndType($country, $payoutType)
    {
        return self::where('country', $country)
            ->where('payout_type', $payoutType)
            ->orderBy('bank_name')
            ->get();
    }
    
    /**
     * Get payout types available for a country
     */
    public static function getPayoutTypesByCountry($country)
    {
        return self::where('country', $country)
            ->select('payout_type')
            ->distinct()
            ->orderBy('payout_type')
            ->get()
            ->pluck('payout_type');
    }
}
