<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class BankSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $banks = [
            // BANGLADESH
            ['country' => 'Bangladesh', 'country_code' => 'BD', 'currency_code' => 'BDT', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'BKASH'],
            ['country' => 'Bangladesh', 'country_code' => 'BD', 'currency_code' => 'BDT', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Uttara Bank'],
            ['country' => 'Bangladesh', 'country_code' => 'BD', 'currency_code' => 'BDT', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Pubali Bank'],
            ['country' => 'Bangladesh', 'country_code' => 'BD', 'currency_code' => 'BDT', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Southeast Bank'],
            ['country' => 'Bangladesh', 'country_code' => 'BD', 'currency_code' => 'BDT', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Prime Bank'],
            ['country' => 'Bangladesh', 'country_code' => 'BD', 'currency_code' => 'BDT', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Agrani Bank'],
            ['country' => 'Bangladesh', 'country_code' => 'BD', 'currency_code' => 'BDT', 'payout_type' => 'Cash Pickup', 'bank_name' => 'National Bank'],
            ['country' => 'Bangladesh', 'country_code' => 'BD', 'currency_code' => 'BDT', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Islami Bank'],
            ['country' => 'Bangladesh', 'country_code' => 'BD', 'currency_code' => 'BDT', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Janata Bank'],
            ['country' => 'Bangladesh', 'country_code' => 'BD', 'currency_code' => 'BDT', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Brac Bank'],
            ['country' => 'Bangladesh', 'country_code' => 'BD', 'currency_code' => 'BDT', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Sonali Bank'],
            ['country' => 'Bangladesh', 'country_code' => 'BD', 'currency_code' => 'BDT', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Bank Asia'],
            ['country' => 'Bangladesh', 'country_code' => 'BD', 'currency_code' => 'BDT', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Dutch-Bangla Bank'],
            ['country' => 'Bangladesh', 'country_code' => 'BD', 'currency_code' => 'BDT', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Jamuna Bank'],
            ['country' => 'Bangladesh', 'country_code' => 'BD', 'currency_code' => 'BDT', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Mercantile Bank'],
            ['country' => 'Bangladesh', 'country_code' => 'BD', 'currency_code' => 'BDT', 'payout_type' => 'Cash Pickup', 'bank_name' => 'National Credit & Commerce Bank'],
            ['country' => 'Bangladesh', 'country_code' => 'BD', 'currency_code' => 'BDT', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Bangladesh Krishi Bank'],
            ['country' => 'Bangladesh', 'country_code' => 'BD', 'currency_code' => 'BDT', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Rupali Bank Limited'],
            ['country' => 'Bangladesh', 'country_code' => 'BD', 'currency_code' => 'BDT', 'payout_type' => 'Cash Pickup', 'bank_name' => 'IFIC Bank Limited'],
            ['country' => 'Bangladesh', 'country_code' => 'BD', 'currency_code' => 'BDT', 'payout_type' => 'Cash Pickup', 'bank_name' => 'The City Bank Limited'],
            ['country' => 'Bangladesh', 'country_code' => 'BD', 'currency_code' => 'BDT', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Meghna Bank Limited'],
            ['country' => 'Bangladesh', 'country_code' => 'BD', 'currency_code' => 'BDT', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Union Bank Limited'],
            ['country' => 'Bangladesh', 'country_code' => 'BD', 'currency_code' => 'BDT', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Social Islami Bank Bangladesh'],
            ['country' => 'Bangladesh', 'country_code' => 'BD', 'currency_code' => 'BDT', 'payout_type' => 'Cash Pickup', 'bank_name' => 'First Security Islami Bank'],
            ['country' => 'Bangladesh', 'country_code' => 'BD', 'currency_code' => 'BDT', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Al Arafah Islami Bank'],
            ['country' => 'Bangladesh', 'country_code' => 'BD', 'currency_code' => 'BDT', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Global Islami Bank LTD'],
            ['country' => 'Bangladesh', 'country_code' => 'BD', 'currency_code' => 'BDT', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Mutual Trust Bank'],
            ['country' => 'Bangladesh', 'country_code' => 'BD', 'currency_code' => 'BDT', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Shahjalal Islami Bank'],
            ['country' => 'Bangladesh', 'country_code' => 'BD', 'currency_code' => 'BDT', 'payout_type' => 'Bank Transfer', 'bank_name' => 'All Major Banks'],

            // PAKISTAN
            ['country' => 'Pakistan', 'country_code' => 'PK', 'currency_code' => 'PKR', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'JAZZ CASH'],
            ['country' => 'Pakistan', 'country_code' => 'PK', 'currency_code' => 'PKR', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'EASY PAISA'],
            ['country' => 'Pakistan', 'country_code' => 'PK', 'currency_code' => 'PKR', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Trust Bank'],
            ['country' => 'Pakistan', 'country_code' => 'PK', 'currency_code' => 'PKR', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Modhumoti Bank LTD'],
            ['country' => 'Pakistan', 'country_code' => 'PK', 'currency_code' => 'PKR', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Allied Bank'],
            ['country' => 'Pakistan', 'country_code' => 'PK', 'currency_code' => 'PKR', 'payout_type' => 'Cash Pickup', 'bank_name' => 'United Bank Pakistan'],
            ['country' => 'Pakistan', 'country_code' => 'PK', 'currency_code' => 'PKR', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Askari Bank Limited'],
            ['country' => 'Pakistan', 'country_code' => 'PK', 'currency_code' => 'PKR', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Bank of Punjab'],
            ['country' => 'Pakistan', 'country_code' => 'PK', 'currency_code' => 'PKR', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Meezan Bank'],
            ['country' => 'Pakistan', 'country_code' => 'PK', 'currency_code' => 'PKR', 'payout_type' => 'Cash Pickup', 'bank_name' => 'National Bank of Pakistan'],
            ['country' => 'Pakistan', 'country_code' => 'PK', 'currency_code' => 'PKR', 'payout_type' => 'Cash Pickup', 'bank_name' => 'MCB Bank Limited'],
            ['country' => 'Pakistan', 'country_code' => 'PK', 'currency_code' => 'PKR', 'payout_type' => 'Cash Pickup', 'bank_name' => 'JS Bank'],
            ['country' => 'Pakistan', 'country_code' => 'PK', 'currency_code' => 'PKR', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Bank Al Habib'],
            ['country' => 'Pakistan', 'country_code' => 'PK', 'currency_code' => 'PKR', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Bank of Khyber'],
            ['country' => 'Pakistan', 'country_code' => 'PK', 'currency_code' => 'PKR', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Bank Alfalah Limited'],
            ['country' => 'Pakistan', 'country_code' => 'PK', 'currency_code' => 'PKR', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Soneri Bank'],
            ['country' => 'Pakistan', 'country_code' => 'PK', 'currency_code' => 'PKR', 'payout_type' => 'Bank Transfer', 'bank_name' => 'All Major Banks'],

            // INDIA
            ['country' => 'India', 'country_code' => 'IN', 'currency_code' => 'INR', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Mastercard Money Transfer Services India'],
            ['country' => 'India', 'country_code' => 'IN', 'currency_code' => 'INR', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Ebixcash World Money India Limited'],
            ['country' => 'India', 'country_code' => 'IN', 'currency_code' => 'INR', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Ebix Money Express PVT LTD'],
            ['country' => 'India', 'country_code' => 'IN', 'currency_code' => 'INR', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Muthoot Forex'],
            ['country' => 'India', 'country_code' => 'IN', 'currency_code' => 'INR', 'payout_type' => 'Bank Transfer', 'bank_name' => 'All Major Banks'],

            // NEPAL
            ['country' => 'Nepal', 'country_code' => 'NP', 'currency_code' => 'NPR', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Nepal Investment Bank'],
            ['country' => 'Nepal', 'country_code' => 'NP', 'currency_code' => 'NPR', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Prabhu Money Transfer P. LTD'],
            ['country' => 'Nepal', 'country_code' => 'NP', 'currency_code' => 'NPR', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Sunrise Bank LTD'],
            ['country' => 'Nepal', 'country_code' => 'NP', 'currency_code' => 'NPR', 'payout_type' => 'Cash Pickup', 'bank_name' => 'City Express Money Transfer'],
            ['country' => 'Nepal', 'country_code' => 'NP', 'currency_code' => 'NPR', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Century Commercial Bank LTD'],
            ['country' => 'Nepal', 'country_code' => 'NP', 'currency_code' => 'NPR', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Everest Bank LTD'],
            ['country' => 'Nepal', 'country_code' => 'NP', 'currency_code' => 'NPR', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Samsara Remit'],
            ['country' => 'Nepal', 'country_code' => 'NP', 'currency_code' => 'NPR', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Ipay Remit'],
            ['country' => 'Nepal', 'country_code' => 'NP', 'currency_code' => 'NPR', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Remit to Nepal'],
            ['country' => 'Nepal', 'country_code' => 'NP', 'currency_code' => 'NPR', 'payout_type' => 'Cash Pickup', 'bank_name' => 'G.M.E. Remit PVT LTD'],
            ['country' => 'Nepal', 'country_code' => 'NP', 'currency_code' => 'NPR', 'payout_type' => 'Bank Transfer', 'bank_name' => 'All Major Banks'],

            // EGYPT
            ['country' => 'Egypt', 'country_code' => 'EG', 'currency_code' => 'EGP', 'payout_type' => 'Cash Pickup', 'bank_name' => 'United Bank of Egypt'],
            ['country' => 'Egypt', 'country_code' => 'EG', 'currency_code' => 'EGP', 'payout_type' => 'Bank Transfer', 'bank_name' => 'All Major Banks'],

            // ETHIOPIA
            ['country' => 'Ethiopia', 'country_code' => 'ET', 'currency_code' => 'ETB', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Commercial Bank of Ethiopia'],
            ['country' => 'Ethiopia', 'country_code' => 'ET', 'currency_code' => 'ETB', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Ormia International Bank'],
            ['country' => 'Ethiopia', 'country_code' => 'ET', 'currency_code' => 'ETB', 'payout_type' => 'Bank Transfer', 'bank_name' => 'All Major Banks'],

            // GHANA
            ['country' => 'Ghana', 'country_code' => 'GH', 'currency_code' => 'GHS', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'MTN (MoMo)'],
            ['country' => 'Ghana', 'country_code' => 'GH', 'currency_code' => 'GHS', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'Airtel'],
            ['country' => 'Ghana', 'country_code' => 'GH', 'currency_code' => 'GHS', 'payout_type' => 'Cash Pickup', 'bank_name' => 'First Atlantic Bank'],
            ['country' => 'Ghana', 'country_code' => 'GH', 'currency_code' => 'GHS', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Fidelity Bank'],
            ['country' => 'Ghana', 'country_code' => 'GH', 'currency_code' => 'GHS', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Republic Bank Ghana Limited'],
            ['country' => 'Ghana', 'country_code' => 'GH', 'currency_code' => 'GHS', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Universal Merchant Bank Limited'],
            ['country' => 'Ghana', 'country_code' => 'GH', 'currency_code' => 'GHS', 'payout_type' => 'Cash Pickup', 'bank_name' => 'FBN Bank'],
            ['country' => 'Ghana', 'country_code' => 'GH', 'currency_code' => 'GHS', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Agricultural Development Bank (ADB Bank)'],
            ['country' => 'Ghana', 'country_code' => 'GH', 'currency_code' => 'GHS', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Prudential Bank Limited'],
            ['country' => 'Ghana', 'country_code' => 'GH', 'currency_code' => 'GHS', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Omnibsic Bank'],
            ['country' => 'Ghana', 'country_code' => 'GH', 'currency_code' => 'GHS', 'payout_type' => 'Cash Pickup', 'bank_name' => 'GCB Bank Limited'],
            ['country' => 'Ghana', 'country_code' => 'GH', 'currency_code' => 'GHS', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Consolidated Bank of Ghana'],
            ['country' => 'Ghana', 'country_code' => 'GH', 'currency_code' => 'GHS', 'payout_type' => 'Bank Transfer', 'bank_name' => 'All Major Banks'],

            // NIGERIA
            ['country' => 'Nigeria', 'country_code' => 'NG', 'currency_code' => 'NGN', 'payout_type' => 'Bank Transfer', 'bank_name' => 'All Major Banks'],

            // UGANDA
            ['country' => 'Uganda', 'country_code' => 'UG', 'currency_code' => 'UGX', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'MTN (MoMo)'],
            ['country' => 'Uganda', 'country_code' => 'UG', 'currency_code' => 'UGX', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'Airtel'],
            ['country' => 'Uganda', 'country_code' => 'UG', 'currency_code' => 'UGX', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Pay Uganda'],
            ['country' => 'Uganda', 'country_code' => 'UG', 'currency_code' => 'UGX', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Equity Bank'],
            ['country' => 'Uganda', 'country_code' => 'UG', 'currency_code' => 'UGX', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Postbank Uganda'],
            ['country' => 'Uganda', 'country_code' => 'UG', 'currency_code' => 'UGX', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Unimoni Exchange'],
            ['country' => 'Uganda', 'country_code' => 'UG', 'currency_code' => 'UGX', 'payout_type' => 'Bank Transfer', 'bank_name' => 'All Major Banks'],

            // RWANDA
            ['country' => 'Rwanda', 'country_code' => 'RW', 'currency_code' => 'RWF', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'MTN (MoMo)'],

            // TANZANIA
            ['country' => 'Tanzania', 'country_code' => 'TZ', 'currency_code' => 'TZS', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'Airtel'],
            ['country' => 'Tanzania', 'country_code' => 'TZ', 'currency_code' => 'TZS', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'MTN (MoMo)'],
            ['country' => 'Tanzania', 'country_code' => 'TZ', 'currency_code' => 'TZS', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'Vodacom (Mpesa)'],
            ['country' => 'Tanzania', 'country_code' => 'TZ', 'currency_code' => 'TZS', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'Tigo (Pesa)'],

            // CAMEROON
            ['country' => 'Cameroon', 'country_code' => 'CM', 'currency_code' => 'CFA', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'MTN'],
            ['country' => 'Cameroon', 'country_code' => 'CM', 'currency_code' => 'CFA', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'Orange'],
            ['country' => 'Cameroon', 'country_code' => 'CM', 'currency_code' => 'CFA', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Exchange House Limited Company'],
            ['country' => 'Cameroon', 'country_code' => 'CM', 'currency_code' => 'CFA', 'payout_type' => 'Cash Pickup', 'bank_name' => 'First Trust Savings and Loan'],
            ['country' => 'Cameroon', 'country_code' => 'CM', 'currency_code' => 'CFA', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Leadex S.A'],
            ['country' => 'Cameroon', 'country_code' => 'CM', 'currency_code' => 'CFA', 'payout_type' => 'Cash Pickup', 'bank_name' => 'FIGEC'],
            ['country' => 'Cameroon', 'country_code' => 'CM', 'currency_code' => 'CFA', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Express Union'],
            ['country' => 'Cameroon', 'country_code' => 'CM', 'currency_code' => 'CFA', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Credit Populaire'],
            ['country' => 'Cameroon', 'country_code' => 'CM', 'currency_code' => 'CFA', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Mupecl'],
            ['country' => 'Cameroon', 'country_code' => 'CM', 'currency_code' => 'CFA', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Free Cash'],
            ['country' => 'Cameroon', 'country_code' => 'CM', 'currency_code' => 'CFA', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Express Exchange'],
            ['country' => 'Cameroon', 'country_code' => 'CM', 'currency_code' => 'CFA', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Victoria Forex (200+ locations)'],

            // MALAWI
            ['country' => 'Malawi', 'country_code' => 'MW', 'currency_code' => 'MWK', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'Airtel (Airtel Money)'],
            ['country' => 'Malawi', 'country_code' => 'MW', 'currency_code' => 'MWK', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'TNM (Mpamba)'],

            // KENYA
            ['country' => 'Kenya', 'country_code' => 'KE', 'currency_code' => 'KES', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'Vodacom (Mpesa)'],
            ['country' => 'Kenya', 'country_code' => 'KE', 'currency_code' => 'KES', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Upesi Money Transfer (NGAO Credit LTD)'],
            ['country' => 'Kenya', 'country_code' => 'KE', 'currency_code' => 'KES', 'payout_type' => 'Cash Pickup', 'bank_name' => 'SBM Bank (Mauritius) LTD'],
            ['country' => 'Kenya', 'country_code' => 'KE', 'currency_code' => 'KES', 'payout_type' => 'Cash Pickup', 'bank_name' => 'KCB Bank'],
            ['country' => 'Kenya', 'country_code' => 'KE', 'currency_code' => 'KES', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Equity Bank'],
            ['country' => 'Kenya', 'country_code' => 'KE', 'currency_code' => 'KES', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Cooperative Bank'],
            ['country' => 'Kenya', 'country_code' => 'KE', 'currency_code' => 'KES', 'payout_type' => 'Bank Transfer', 'bank_name' => 'All Major Banks'],

            // MOZAMBIQUE
            ['country' => 'Mozambique', 'country_code' => 'MZ', 'currency_code' => 'MZN', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'Vodacom (Mpesa)'],

            // ZAMBIA
            ['country' => 'Zambia', 'country_code' => 'ZM', 'currency_code' => 'ZMW', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'AIRTEL'],
            ['country' => 'Zambia', 'country_code' => 'ZM', 'currency_code' => 'ZMW', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'MTN'],
            ['country' => 'Zambia', 'country_code' => 'ZM', 'currency_code' => 'ZMW', 'payout_type' => 'Bank Transfer', 'bank_name' => 'All Major Banks'],

            // UAE
            ['country' => 'United Arab Emirates', 'country_code' => 'AE', 'currency_code' => 'AED', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Al Rozouki Intl Exchange CO'],
            ['country' => 'United Arab Emirates', 'country_code' => 'AE', 'currency_code' => 'AED', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Al Ghurair Intl Exchange'],
            ['country' => 'United Arab Emirates', 'country_code' => 'AE', 'currency_code' => 'AED', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Orient Exchange'],
            ['country' => 'United Arab Emirates', 'country_code' => 'AE', 'currency_code' => 'AED', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Saad Exchange'],
            ['country' => 'United Arab Emirates', 'country_code' => 'AE', 'currency_code' => 'AED', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Al Dhafra Exchange'],
            ['country' => 'United Arab Emirates', 'country_code' => 'AE', 'currency_code' => 'AED', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Al Bader Exchange'],
            ['country' => 'United Arab Emirates', 'country_code' => 'AE', 'currency_code' => 'AED', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Emirates India Intl Ex'],
            ['country' => 'United Arab Emirates', 'country_code' => 'AE', 'currency_code' => 'AED', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Al Ahalia Money Exchange Bureau'],
            ['country' => 'United Arab Emirates', 'country_code' => 'AE', 'currency_code' => 'AED', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Al Fardan Exchange'],
            ['country' => 'United Arab Emirates', 'country_code' => 'AE', 'currency_code' => 'AED', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Lulu International Exchange'],
            ['country' => 'United Arab Emirates', 'country_code' => 'AE', 'currency_code' => 'AED', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Sama Exchange'],
            ['country' => 'United Arab Emirates', 'country_code' => 'AE', 'currency_code' => 'AED', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Expert Exchange'],
            ['country' => 'United Arab Emirates', 'country_code' => 'AE', 'currency_code' => 'AED', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Omda Exchange'],
            ['country' => 'United Arab Emirates', 'country_code' => 'AE', 'currency_code' => 'AED', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Deniba International Exchange'],
            ['country' => 'United Arab Emirates', 'country_code' => 'AE', 'currency_code' => 'AED', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Capital Exchange'],
            ['country' => 'United Arab Emirates', 'country_code' => 'AE', 'currency_code' => 'AED', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Economic Exchange'],

            // ETHIOPIA (United Bank S.C, Awash, Wegagen, NIB, Enat, Abay, Bank of Abyssinia, Dashen, Addis International, Lion International, Bunna, Cooperative Bank of Ormia, Berhan International)
            ['country' => 'Ethiopia', 'country_code' => 'ET', 'currency_code' => 'ETB', 'payout_type' => 'Cash Pickup', 'bank_name' => 'United Bank S.C'],
            ['country' => 'Ethiopia', 'country_code' => 'ET', 'currency_code' => 'ETB', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Awash International Bank S.C'],
            ['country' => 'Ethiopia', 'country_code' => 'ET', 'currency_code' => 'ETB', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Wegagen Bank S.C'],
            ['country' => 'Ethiopia', 'country_code' => 'ET', 'currency_code' => 'ETB', 'payout_type' => 'Cash Pickup', 'bank_name' => 'NIB International Bank S.C'],
            ['country' => 'Ethiopia', 'country_code' => 'ET', 'currency_code' => 'ETB', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Enat Bank S.C'],
            ['country' => 'Ethiopia', 'country_code' => 'ET', 'currency_code' => 'ETB', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Abay Bank S.C'],
            ['country' => 'Ethiopia', 'country_code' => 'ET', 'currency_code' => 'ETB', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Bank of Abyssinia S.C'],
            ['country' => 'Ethiopia', 'country_code' => 'ET', 'currency_code' => 'ETB', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Dashen Bank'],
            ['country' => 'Ethiopia', 'country_code' => 'ET', 'currency_code' => 'ETB', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Addis International Bank'],
            ['country' => 'Ethiopia', 'country_code' => 'ET', 'currency_code' => 'ETB', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Lion International Bank S.C'],
            ['country' => 'Ethiopia', 'country_code' => 'ET', 'currency_code' => 'ETB', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Bunna International Bank S.C'],
            ['country' => 'Ethiopia', 'country_code' => 'ET', 'currency_code' => 'ETB', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Cooperative Bank of Ormia'],
            ['country' => 'Ethiopia', 'country_code' => 'ET', 'currency_code' => 'ETB', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Berhan International Bank'],

            // NEW ZEALAND
            ['country' => 'New Zealand', 'country_code' => 'NZ', 'currency_code' => 'NZD', 'payout_type' => 'Bank Transfer', 'bank_name' => 'All Major Banks'],

            // CANADA
            ['country' => 'Canada', 'country_code' => 'CA', 'currency_code' => 'CAD', 'payout_type' => 'Bank Transfer', 'bank_name' => 'All Major Banks'],

            // THAILAND
            ['country' => 'Thailand', 'country_code' => 'TH', 'currency_code' => 'THB', 'payout_type' => 'Bank Transfer', 'bank_name' => 'All Major Banks'],

            // BURUNDI
            ['country' => 'Burundi', 'country_code' => 'BI', 'currency_code' => 'BIF', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'Econet'],

            // DRC
            ['country' => 'DRC', 'country_code' => 'CD', 'currency_code' => 'USD', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'Airtel'],
            ['country' => 'DRC', 'country_code' => 'CD', 'currency_code' => 'USD', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Equity Bank'],
            ['country' => 'DRC', 'country_code' => 'CD', 'currency_code' => 'USD', 'payout_type' => 'Cash Pickup', 'bank_name' => 'Cash Express'],
            ['country' => 'DRC', 'country_code' => 'CD', 'currency_code' => 'USD', 'payout_type' => 'Bank Transfer', 'bank_name' => 'All Major Banks'],

            // MALI
            ['country' => 'Mali', 'country_code' => 'ML', 'currency_code' => 'XOF', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'Orange'],

            // IVORY COAST
            ['country' => 'Ivory Coast', 'country_code' => 'CI', 'currency_code' => 'XOF', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'MTN'],
            ['country' => 'Ivory Coast', 'country_code' => 'CI', 'currency_code' => 'XOF', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'Orange'],

            // SENEGAL
            ['country' => 'Senegal', 'country_code' => 'SN', 'currency_code' => 'XOF', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'Orange'],
            ['country' => 'Senegal', 'country_code' => 'SN', 'currency_code' => 'XOF', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'Wave'],

            // BURKINA FASO
            ['country' => 'Burkina Faso', 'country_code' => 'BF', 'currency_code' => 'XOF', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'Orange'],

            // CHINA
            ['country' => 'China', 'country_code' => 'CN', 'currency_code' => 'CNY', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'Alipay'],

            // ZIMBABWE
            ['country' => 'Zimbabwe', 'country_code' => 'ZW', 'currency_code' => 'USD', 'payout_type' => 'Mobile Wallet', 'bank_name' => 'Ecocash'],
            ['country' => 'Zimbabwe', 'country_code' => 'ZW', 'currency_code' => 'USD', 'payout_type' => 'Cash Pickup', 'bank_name' => 'CBZ'],

            // SRI LANKA
            ['country' => 'Sri Lanka', 'country_code' => 'LK', 'currency_code' => 'SLR', 'payout_type' => 'Bank Transfer', 'bank_name' => 'All Major Banks'],

            // TURKEY
            ['country' => 'Turkey', 'country_code' => 'TR', 'currency_code' => 'TRY', 'payout_type' => 'Bank Transfer', 'bank_name' => 'All Major Banks'],

            // UNITED KINGDOM
            ['country' => 'United Kingdom', 'country_code' => 'GB', 'currency_code' => 'GBP', 'payout_type' => 'Bank Transfer', 'bank_name' => 'All Major Banks'],
        ];

        DB::table('banks')->insert($banks);
    }
}
