<!-- Call to Action Section - Reusable Component -->
<!-- Desktop CTA -->
<section class="hidden lg:block py-20 bg-[#F5F5F7] relative overflow-hidden">
    <div class="container mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
        <!-- Card Container with seamless gradient -->
        <div class="rounded-3xl overflow-hidden shadow-2xl relative h-80 sm:h-96 lg:h-[400px]">
            <div class="absolute inset-0 flex">
                <!-- Left Content: Text and Button -->
                 <div class="w-full lg:w-1/2 px-8 sm:px-12 py-12 lg:py-16 flex flex-col justify-center bg-gradient-to-r from-[#0a0e27] via-[#0f1829] to-[#1a2d42]">
                        <h2 class="text-xl sm:text-2xl lg:text-3xl text-white mb-6 leading-tight" style="font-family: 'Red Hat Display', sans-serif;">
                            An affordable, efficient and secure way to send money home.
                        </h2>
                        <p class="text-gray-300 text-base sm:text-lg mb-16">Sign up and save on your next transfer</p>
                        <button class="text-white font-semibold py-4 px-10 rounded-lg shadow-lg transition transform hover:scale-105 w-fit text-lg" style="background-color: #00B5C5;" onmouseover="this.style.backgroundColor='#0095a3'" onmouseout="this.style.backgroundColor='#00B5C5'">
                            Download App
                        </button>
                 </div>

                <!-- Right Content: Image with overlay (Desktop only) -->
                <div class="hidden lg:flex w-1/2 items-center justify-center overflow-hidden relative">
                    <img src="/images/design161.png" alt="Family sending money" class="w-full h-full object-cover">
                    <div class="absolute inset-0 bg-gradient-to-r from-[#0a1f3a]/80 via-[#0d2a45]/60 to-[#1a3a52]/40"></div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Mobile CTA Card with Image (Mobile only) -->
<section class="lg:hidden py-8 px-4 sm:px-6 bg-white">
    <div class="container mx-auto max-w-sm">
        <div class="relative bg-gradient-to-b from-[#0a0e27] via-[#0f1829] to-[#1a2d42] rounded-3xl overflow-hidden shadow-lg h-[700px]">
            <!-- Background Image with Gradient -->
            <div class="absolute inset-0">
                <img src="/images/design161.png" alt="Family using Home Remitt" class="absolute bottom-0 left-0 right-0 w-full h-[320px] object-contain translate-y-9">
                <div class="absolute inset-0 bg-gradient-to-b from-[#031528]/100 via-[#031528]/100 to-transparent"></div>
                <div class="absolute inset-0 bg-gradient-to-b from-[#031528]/100 via-[#031528]/100 to-transparent"></div>
                <div class="absolute inset-0 bg-gradient-to-b from-[#031528]/100 via-[#031528]/100 to-transparent"></div>
                <div class="absolute inset-0 bg-gradient-to-b from-[#031528]/100 via-[#031528]/100 to-transparent"></div>
            </div>

            <!-- Content -->
            <div class="relative z-10 p-6 sm:p-8 h-full flex flex-col justify-start pt-8">
                <div class="mb-12">
                    <h2 class="text-4xl sm:text-3xl text-white mb-4 leading-tight" style="font-family: 'Red Hat Display', sans-serif;">
                        An affordable,<br>efficient and secure<br>way to send money<br>home.
                    </h2>
                    <p class="text-gray-300 text-sm sm:text-base mb-8">Sign up and save on your next transfer</p>
                </div>
                <button class="text-white font-semibold py-3 px-8 rounded-lg shadow-lg transition transform hover:scale-105 w-fit text-base" style="background-color: #00B5C5;" onmouseover="this.style.backgroundColor='#0095a3'" onmouseout="this.style.backgroundColor='#00B5C5'">
                    Download App
                </button>
            </div>
        </div>
    </div>
</section>
