@extends('layouts.app')

@section('title', 'Sign Up - Home Remitt')

@push('styles')
<link rel="stylesheet" href="{{ asset('css/shared-styles.css') }}">
<style>
    .form-input {
        background-color: #0f172a;
        border: 1px solid #1e293b;
        color: white;
        transition: border-color 0.3s ease;
    }
    .form-input:focus {
        border-color: #22d3ee;
        outline: none;
        background-color: #1e293b;
    }
    .signup-container {
        min-height: calc(100vh - 80px);
    }
</style>
@endpush

@section('content')

<section class="relative pt-28 pb-16">
    <div class="container mx-auto max-w-6xl px-4 sm:px-6 lg:px-8">
        
        <!-- Main Card Container -->
        <div class="bg-[#050B1F] rounded-3xl overflow-hidden shadow-2xl flex flex-col lg:flex-row border border-gray-800">
            
            <!-- Left Side: Image & Text -->
            <div class="lg:w-2/5 relative min-h-[500px] lg:min-h-full">
                <!-- Background Image -->
                <div class="absolute inset-0">
                    <img src="https://placehold.co/600x900/1a202c/FFF?text=Man+Smiling+Phone" alt="Sign Up" class="w-full h-full object-cover">
                    <!-- Gradient Overlay -->
                    <div class="absolute inset-0 bg-gradient-to-t from-[#050B1F] via-transparent to-transparent opacity-90"></div>
                    <div class="absolute inset-0 bg-black/40"></div>
                </div>

                <!-- Text Overlay -->
                <div class="absolute bottom-0 left-0 right-0 p-8 z-10">
                    <h2 class="text-3xl font-bold text-white mb-3">Sign up</h2>
                    <p class="text-gray-300 text-sm mb-6 leading-relaxed">
                        No queues. No stress. With Home Remitt, signing up is quick and sending money home is affordable, efficient and secure.
                    </p>
                    <button class="border border-white/30 text-white hover:bg-white hover:text-blue-900 font-medium py-2 px-6 rounded-lg transition backdrop-blur-sm">
                        Download App
                    </button>
                </div>
            </div>

            <!-- Right Side: Form -->
            <div class="lg:w-3/5 p-8 md:p-12 bg-[#050B1F]">
                <h2 class="text-3xl font-bold text-white mb-8">Sign Me Up</h2>
                
                <form action="#" method="POST" class="space-y-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-2">Name</label>
                        <div class="relative">
                            <span class="absolute inset-y-0 left-0 pl-3 flex items-center text-cyan-500">
                                <i class="far fa-user"></i>
                            </span>
                            <input type="text" placeholder="Enter your name" class="w-full pl-10 pr-4 py-3 rounded-lg form-input text-sm">
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-2">Email</label>
                        <div class="relative">
                            <span class="absolute inset-y-0 left-0 pl-3 flex items-center text-cyan-500">
                                <i class="far fa-envelope"></i>
                            </span>
                            <input type="email" placeholder="Enter your email" class="w-full pl-10 pr-4 py-3 rounded-lg form-input text-sm">
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-2">Phone Number</label>
                        <div class="relative">
                            <span class="absolute inset-y-0 left-0 pl-3 flex items-center text-cyan-500">
                                <i class="fas fa-mobile-alt"></i>
                            </span>
                            <input type="tel" placeholder="Enter your phone Number" class="w-full pl-10 pr-4 py-3 rounded-lg form-input text-sm">
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-2">Message</label>
                        <textarea rows="4" placeholder="Your Message..." class="w-full px-4 py-3 rounded-lg form-input text-sm resize-none"></textarea>
                    </div>

                    <div class="flex justify-end pt-2">
                        <button type="button" class="bg-cyan-500 hover:bg-cyan-600 text-white font-bold py-3 px-8 rounded-lg transition shadow-lg w-full md:w-auto">
                            Send Message
                        </button>
                    </div>
                </form>
            </div>

        </div>
        
    </div>
</section>

<!-- Bottom Banner (Matches Image Layout) -->
<section class="pb-20">
    <div class="container mx-auto max-w-6xl px-4 sm:px-6 lg:px-8">
        <div class="bg-[#1B274B] rounded-3xl p-8 md:p-12 relative overflow-hidden flex flex-col md:flex-row items-center justify-between">
            <div class="z-10 md:w-1/2">
                <h2 class="text-2xl md:text-3xl font-bold text-white mb-3">An affordable, efficient and secure<br>way to send money home.</h2>
                <p class="text-gray-400 mb-8">Sign up and save on your next transfer</p>
                <button class="bg-cyan-500 hover:bg-cyan-600 text-white font-bold py-3 px-8 rounded-lg transition shadow-lg">
                    Download App
                </button>
            </div>
            
            <!-- Image mockup on right -->
            <div class="mt-8 md:mt-0 md:w-1/2 flex justify-center md:justify-end relative z-0">
                <div class="absolute inset-0 bg-blue-500/10 blur-3xl rounded-full"></div>
                <img src="https://placehold.co/400x300/1a202c/FFF?text=Family+on+Couch" alt="Family" class="rounded-xl shadow-2xl relative z-10 mask-image-gradient">
            </div>
        </div>
    </div>
</section>

<!-- Footer -->
@include('components.shared-footer')

@endsection