@extends('layouts.app')

@section('title', 'Terms and Conditions - Home Remitt')

@push('styles')
<style>
    body {
        background-color: #070F2B;
        color: #FFFFFF;
    }
</style>
@endpush

@section('content')

<div class="relative pt-32 pb-20">
    <div class="container mx-auto max-w-4xl px-4 sm:px-6 lg:px-8">
        
        <div class="bg-[#1B274B] rounded-2xl p-8 md:p-12 shadow-2xl">
            <h1 class="text-3xl md:text-4xl font-bold mb-8 pb-4 border-b border-gray-700">Terms and Conditions</h1>
            
            <div class="space-y-6 text-gray-300">
                <p class="italic text-sm text-gray-400 mb-6">By using our services, you agree to the terms listed here with you and Home Remitt. Please review the conditions of our business relationship.</p>
                
                <p>I accept that I am entering into a business relationship with Home Remitt (Pty) Ltd, hereinafter referred to as HR, and accept and agree that:</p>
                
                <ol class="list-decimal pl-5 space-y-4 marker:text-cyan-500">
                    <li>These terms and conditions will remain in force until such time as the business relationship between myself and HR is cancelled by me in writing. HR may terminate the business relationship between itself and me and withdraw from the arrangement at any time by giving me notification of such intention.</li>
                    
                    <li>All information provided by me to HR is true and correct.</li>
                    
                    <li>HR is regulated by the South African Reserve Bank and the Financial Intelligence Centre. In this regard, I will not use the HR Service for any other purpose apart from the Services under which it is authorized to offer.</li>
                    
                    <li>I authorize HR to sign the balance of payments integrated form on my behalf to meet its regulatory obligation.</li>
                    
                    <li>With respect to transactions concluded under the purpose "Gift" (i.e. BOP Category 401), transactions of this nature may not be sent to self.</li>
                    
                    <li>I authorize HR to accept instructions from me given to HR via telephone and electronic means including, but not limited to, facsimile, email, internet, text message from a mobile phone, Unstructured Supplementary Service Data (USSD) and mobile phone applications.</li>
                    
                    <li>All telephonic and electronic communications that claim to come from me to HR will be deemed to have come from me. While HR will take reasonable steps to ensure that all communications are authentic and come from me, it is not possible for HR to establish the authenticity of all instructions that claim to come from me.</li>
                    
                    <li>All telephonic and electronic instructions that claim to come from me shall give HR an irrevocable and unconditional authority to act on should it elect to.</li>
                    
                    <li>HR accepts no liability for losses incurred by me for any cause whatsoever as a result of HR allowing me to communicate instructions by telephone or electronic means. I waive any rights that I have or may obtain against HR arising directly or indirectly from any losses or damages which I may suffer because HR acts on any instruction.</li>
                    
                    <li>HR may vary these terms and conditions from time to time by notifying me of such variations. I hereby confirm and agree to the Home Remitt terms and conditions.</li>
                </ol>
            </div>
            
            <div class="mt-10 pt-6 border-t border-gray-700 flex flex-col sm:flex-row gap-4">
                <button class="bg-cyan-500 hover:bg-cyan-600 text-white font-bold py-3 px-8 rounded-lg transition shadow-lg w-full sm:w-auto text-center">
                    Accept Terms
                </button>
                <button class="bg-transparent border border-gray-500 text-gray-300 hover:text-white font-bold py-3 px-8 rounded-lg transition w-full sm:w-auto text-center">
                    Download PDF
                </button>
            </div>
        </div>

    </div>
</div>

@endsection