<?php $__env->startSection('title', 'Send Money - Home Remitt'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    body {
        background-color: #070F2B;
        color: #FFFFFF;
        overflow-x: hidden;
    }
    
    .text-cyan-brand {
        color: #22d3ee;
    }
    
    .bg-cyan-brand {
        background-color: #22d3ee;
    }
    
    .hover-bg-cyan-brand:hover {
        background-color: #06b6d4;
    }
    
    /* Gradient Text */
    .text-gradient-orange-cyan {
        background: linear-gradient(90deg, #FFB300 0%, #FF8C00 40%, #FF6347 60%, #00BCD4 100%);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
    }
    
    .text-gradient-cyan {
        background: linear-gradient(90deg, #0d8fa3 0%, #0d8fa3 50%, #000000 100%);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
    }
    
    /* Backgrounds */
    .hero-bg {
        background-image: url('/images/banner1.jpg');
        background-size: cover;
        background-position: center center;
    }
    
    .calculator-card {
        background-color: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(10px);
    }

    .partner-logo {
        background-color: #0B1435;
        border: 1px solid #1f2937;
        transition: all 0.2s;
    }
    
    .partner-logo:hover {
        border-color: #22d3ee;
        transform: translateY(-2px);
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<!-- Hero Section -->
<section class="relative pt-20 pb-16 overflow-visible bg-[#031528]">
    <div class="container mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
        
        <!-- Banner with overlaid content -->
        <div class="relative mb-10">
            <!-- Banner with Dark Background (No Image) -->
            <div class="relative w-full rounded-2xl overflow-hidden h-64 sm:h-80 lg:h-96 bg-gradient-to-r from-[#031528] to-[#0a1f3b]">
                <!-- Subtle Grid/Pattern Background -->
                <div class="absolute inset-0 opacity-5">
                    <div class="absolute inset-0" style="background-image: linear-gradient(0deg, transparent 24%, rgba(255,255,255,.05) 25%, rgba(255,255,255,.05) 26%, transparent 27%, transparent 74%, rgba(255,255,255,.05) 75%, rgba(255,255,255,.05) 76%, transparent 77%, transparent), linear-gradient(90deg, transparent 24%, rgba(255,255,255,.05) 25%, rgba(255,255,255,.05) 26%, transparent 27%, transparent 74%, rgba(255,255,255,.05) 75%, rgba(255,255,255,.05) 76%, transparent 77%, transparent); background-size: 50px 50px;"></div>
                </div>
                
                <!-- Text Content Overlay (Left side) -->
                <div class="absolute inset-0 flex flex-col justify-center px-4 sm:px-6 lg:px-8 rounded-2xl">
                    <h1 class="text-3xl sm:text-4xl lg:text-5xl font-bold text-white leading-tight max-w-lg">
                        <span class="text-gradient-orange-cyan">Send Money</span>
                    </h1>
                    <h2 class="text-2xl sm:text-3xl lg:text-4xl font-bold text-white mt-2">
                        online to <span class="text-cyan-400">Pakistan</span>
                    </h2>
                    <p class="mt-4 text-sm sm:text-base text-gray-300 max-w-lg leading-relaxed">
                        Affordable international transfers with great rates on every transaction.
                    </p>
                    
                    <div class="mt-6 flex flex-col gap-3 max-w-xs">
                        <div class="flex flex-wrap gap-3">
                            <a href="#" class="inline-block hover:opacity-80 transition">
                                <img src="https://upload.wikimedia.org/wikipedia/commons/7/78/Google_Play_Store_badge_EN.svg" alt="Google Play" class="h-10">
                            </a>
                            <a href="#" class="inline-block hover:opacity-80 transition">
                                <img src="https://upload.wikimedia.org/wikipedia/commons/3/3c/Download_on_the_App_Store_Badge.svg" alt="App Store" class="h-10">
                            </a>
                        </div>
                        <a href="#" class="inline-block hover:opacity-80 transition">
                            <img src="/images/appgallery.png" alt="AppGallery" class="h-10">
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- Calculator Widget (overlaps on desktop) -->
            <div class="relative w-full sm:w-96 mx-auto lg:w-[500px] lg:absolute lg:right-12 lg:top-40 lg:mx-0 px-4 mt-12 sm:mt-16 lg:mt-0">
                <div class="bg-white rounded-2xl p-6 shadow-2xl relative z-10">
                    <div class="mb-5 text-center">
                        <h3 class="text-lg font-bold" style="color: #072538; font-family: 'Red Hat Display', sans-serif;">More for your family.</h3>
                        <p class="text-xs text-gray-500 mt-1" style="color: #072538; font-family: 'Red Hat Display', sans-serif;">We make sure more of your money goes to those you love, not to high service fees</p>
                    </div>

                    <!-- Tabs -->
                    <div class="mb-5">
                        <p class="text-xs mb-2" style="color: #072538;">Payout Method</p>
                        <div class="flex space-x-2">
                            <button class="px-3 py-2 text-xs font-medium rounded-md text-white flex-1 text-center" style="background-color: #072538;">Bank Transfer</button>
                            <button class="px-3 py-2 text-xs font-medium rounded-md bg-gray-100 text-gray-600 hover:bg-gray-200 flex-1 text-center">Mobile Wallet</button>
                            <button class="px-3 py-2 text-xs font-medium rounded-md bg-gray-100 text-gray-600 hover:bg-gray-200 flex-1 text-center">Cash Pickup</button>
                        </div>
                    </div>

                    <!-- You Send -->
                    <div class="mb-4">
                        <div class="relative flex flex-col border border-gray-200 rounded-lg bg-gray-50 p-3">
                            <label class="block text-xs mb-2" style="color: #072538;">You send</label>
                            <div class="relative flex items-center">
                                <input type="number" value="800" class="block w-full text-xl font-bold text-gray-900 bg-transparent outline-none [&::-webkit-outer-spin-button]:hidden [&::-webkit-inner-spin-button]:hidden" placeholder="0.00" style="appearance: textfield;">
                                <div class="absolute right-0 flex items-center mr-3">
                                    <button class="flex items-center space-x-2 px-3 py-1">
                                        <div class="w-px h-5 bg-gray-300"></div>
                                        <div class="w-6 h-6 rounded-full overflow-hidden flex items-center justify-center flex-shrink-0">
                                            <img src="<?php echo e(asset('images/sa.png')); ?>" class="w-full h-full object-cover">
                                        </div>
                                        <span class="font-medium text-gray-900 text-sm">ZAR</span>
                                        <svg class="w-4 h-4 text-gray-600" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" /></svg>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- They Receive -->
                    <div class="mb-4">
                        <div class="relative flex flex-col border border-gray-200 rounded-lg bg-gray-50 p-3">
                            <label class="block text-xs mb-2" style="color: #072538;">They receive</label>
                            <div class="relative flex items-center">
                                <input type="text" value="18,694.12" readonly class="block w-full text-xl font-bold text-gray-900 bg-transparent outline-none">
                                <div class="absolute right-0 flex items-center">
                                    <button class="flex items-center space-x-2 px-3 py-1">
                                        <div class="w-px h-5 bg-gray-300"></div>
                                        <img src="<?php echo e(asset('images/pk.png')); ?>" class="object-cover rounded-sm">
                                        <span class="font-medium text-gray-900 text-sm">PKR</span>
                                        <svg class="w-4 h-4 text-gray-600" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" /></svg>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Exchange Rate -->
                    <div class="flex justify-between text-sm mb-5 px-3 py-2 rounded-lg bg-gray-50">
                        <span class="text-gray-600">Exchange Rate</span>
                        <span class="font-medium text-gray-900">$23.50</span>
                    </div>

                    <div class="flex justify-end">
                        <button class="px-8 text-white font-semibold py-3 rounded-lg transition" style="background-color: #072538; hover:background-color: #051d2a;">
                            Transfer
                        </button>
                    </div>
                </div>
            </div>
        </div>

    </div>
</section>


<!-- Where to Send Money Section -->
<section class="py-20 bg-[#031528]" id="payout-section">
    <div class="container mx-auto max-w-6xl px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h2 class="text-2xl font-bold text-white mb-2">Where to send money</h2>
            <p class="text-gray-400">We offer cash pickup, bank deposit and mobile money options with our trusted network.</p>
        </div>

        <!-- Search / Filter -->
        <div class="flex flex-col md:flex-row gap-4 mb-10 max-w-3xl mx-auto">
            <!-- Sending Country Section -->
            <div class="flex-1">
                <!-- Selected Country Display -->
                <div id="selected-country" class="bg-[#1B274B] p-4 rounded-lg border border-gray-700 cursor-pointer hover:border-cyan-400 transition">
                    <label class="block font-semibold text-xs mb-2" style="color: #929292;">Sending Country</label>
                    <div class="flex items-center justify-between">
                        <div class="flex items-center space-x-3">
                            <span class="font-medium" style="color: #BFBFBF;">South Africa</span>
                        </div>
                        <i class="fas fa-chevron-down text-gray-400"></i>
                    </div>
                </div>
            </div>
            <div class="flex items-center justify-center text-gray-500">
                <i class="fas fa-exchange-alt"></i>
            </div>
            <!-- Receiving Country Section -->
            <div class="flex-1">
                <!-- Country Search Input -->
                <div class="relative bg-[#1B274B] p-4 rounded-lg border border-gray-700 focus-within:border-cyan-400 transition">
                    <label class="block font-semibold text-xs mb-2" style="color: #929292;">Receiving Country</label>
                    <input 
                        id="country-search" 
                        type="text" 
                        placeholder="Search..." 
                        class="w-full bg-transparent text-white placeholder-white-400 focus:outline-none transition pr-10" 
                        style="color: #BFBFBF;"
                    >
                    <svg class="absolute right-3 top-1/2 transform -translate-y-1/2 w-5 h-5 pointer-events-none" style="color: #BFBFBF;" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <circle cx="11" cy="11" r="8"></circle>
                        <path d="m21 21-4.35-4.35"></path>
                    </svg>
                    <!-- Autocomplete Dropdown -->
                    <div id="country-dropdown" class="absolute top-full left-0 right-0 mt-2 bg-[#1B274B] border border-gray-700 rounded-lg shadow-lg max-h-60 overflow-y-auto hidden z-50">
                        <!-- Countries will be populated here -->
                    </div>
                </div>
            </div>
        </div>

        <!-- Payout Method Tabs -->
        <div class="flex justify-center gap-6 mb-12 flex-wrap pb-4 border-b border-gray-700" id="payout-types-container">
            <!-- Payout types will be populated here -->
            <p class="text-gray-400 text-center w-full">Select a country to see available payout methods</p>
        </div>

        <!-- Logos Grid / Banks Display -->
        <div id="banks-container" class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-5 gap-4">
            <p class="text-gray-400 text-center col-span-full">Select a country and payout method to view available banks</p>
        </div>
    </div>
</section>


<!-- Pay In Points -->
<section class="py-20 bg-[#031528]">
    <div class="container mx-auto max-w-6xl px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <span class="text-white font-semibold uppercase text-sm tracking-wider">Pay In Points</span>
            <h2 class="text-3xl md:text-4xl font-bold text-white mt-4 mb-4" style="font-family: 'Red Hat Display', sans-serif;">More for your family, made possible with our trusted partners</h2>
            <p class="text-gray-300 max-w-2xl mx-auto text-base" style="font-family: 'Red Hat Display', sans-serif;">At Home Remitt, we are passionate about ensuring that your loved ones are always supported. We understand that this needs to be as easy as possible, which is why we have chosen these trusted partners, allowing you to send more for your family</p>
        </div>

        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
             <div class="partner-logo h-24 rounded-lg flex items-center justify-center bg-[#1B274B]"><img src="https://placehold.co/120x50/333/fff?text=Checkers" class="h-8"></div>
             <div class="partner-logo h-24 rounded-lg flex items-center justify-center bg-[#1B274B]"><img src="https://placehold.co/120x50/333/fff?text=PicknPay" class="h-8"></div>
             <div class="partner-logo h-24 rounded-lg flex items-center justify-center bg-[#1B274B]"><img src="https://placehold.co/120x50/333/fff?text=SPAR" class="h-8"></div>
             <div class="partner-logo h-24 rounded-lg flex items-center justify-center bg-[#1B274B]"><img src="https://placehold.co/120x50/333/fff?text=Ackermans" class="h-8"></div>
             <div class="partner-logo h-24 rounded-lg flex items-center justify-center bg-[#1B274B]"><img src="https://placehold.co/120x50/333/fff?text=PEP" class="h-8"></div>
             <div class="partner-logo h-24 rounded-lg flex items-center justify-center bg-[#1B274B]"><img src="https://placehold.co/120x50/333/fff?text=Boxer" class="h-8"></div>
             <div class="partner-logo h-24 rounded-lg flex items-center justify-center bg-[#1B274B]"><img src="https://placehold.co/120x50/333/fff?text=Makro" class="h-8"></div>
             <div class="partner-logo h-24 rounded-lg flex items-center justify-center bg-[#1B274B]"><img src="https://placehold.co/120x50/333/fff?text=Flash" class="h-8"></div>
        </div>
    </div>
</section>



<script>
    let selectedCountry = null;
    let selectedPayoutType = null;

    // DOM Elements
    const countrySearchInput = document.getElementById('country-search');
    const countryDropdown = document.getElementById('country-dropdown');
    const selectedCountryDisplay = document.getElementById('selected-country');
    const payoutTypesContainer = document.getElementById('payout-types-container');
    const banksContainer = document.getElementById('banks-container');

    // Initialize with Pakistan as default
    document.addEventListener('DOMContentLoaded', function() {
        const defaultCountry = 'Pakistan';
        const defaultPayoutType = 'Cash Pickup';
        selectedCountry = defaultCountry;
        countrySearchInput.value = defaultCountry;
        
        // Load payout types and then select Cash Pickup
        loadPayoutTypes(defaultCountry).then(() => {
            // Find and click the Cash Pickup button
            setTimeout(function() {
                const buttons = document.querySelectorAll('#payout-types-container button');
                buttons.forEach(btn => {
                    if (btn.dataset.type === defaultPayoutType) {
                        selectPayoutType(defaultPayoutType, btn);
                    }
                });
            }, 300);
        });
    });

    // Country Search with Autocomplete
    countrySearchInput.addEventListener('input', async (e) => {
        const query = e.target.value.trim();
        
        if (query.length < 1) {
            countryDropdown.classList.add('hidden');
            return;
        }

        try {
            const response = await fetch(`/api/countries/search?q=${encodeURIComponent(query)}`);
            const data = await response.json();
            
            if (data.success && data.data.length > 0) {
                renderCountryDropdown(data.data);
                countryDropdown.classList.remove('hidden');
            } else {
                countryDropdown.classList.add('hidden');
            }
        } catch (error) {
            console.error('Error fetching countries:', error);
        }
    });

    // Clear input and show dropdown on focus
    countrySearchInput.addEventListener('focus', function() {
        this.value = '';
        this.selectionStart = 0;
        this.selectionEnd = 0;
    });

    // Render country dropdown options
    function renderCountryDropdown(countries) {
        countryDropdown.innerHTML = '';
        
        countries.forEach(country => {
            const option = document.createElement('div');
            option.className = 'px-4 py-3 hover:bg-[#2a3d63] cursor-pointer text-white border-b border-gray-700 last:border-b-0 transition';
            option.textContent = country.country;
            
            option.addEventListener('click', () => {
                selectCountry(country.country, country.country_code);
            });
            
            countryDropdown.appendChild(option);
        });
    }

    // Select a country
    function selectCountry(country, countryCode) {
        selectedCountry = country;
        countrySearchInput.value = country;
        countryDropdown.classList.add('hidden');
        
        // Reset payout type selection
        selectedPayoutType = null;
        
        // Load payout types for this country and then select Bank Transfer
        loadPayoutTypes(country).then(() => {
            // Find and click the Bank Transfer button
            setTimeout(function() {
                const buttons = document.querySelectorAll('#payout-types-container button');
                buttons.forEach(btn => {
                    if (btn.dataset.type === 'Bank Transfer') {
                        selectPayoutType('Bank Transfer', btn);
                    }
                });
            }, 300);
        });
    }

    // Load payout types for selected country
    async function loadPayoutTypes(country) {
        try {
            const response = await fetch(`/api/payout-types/${encodeURIComponent(country)}`);
            const data = await response.json();
            
            if (data.success && data.data.length > 0) {
                renderPayoutTypes(data.data);
                return true;
            } else {
                payoutTypesContainer.innerHTML = '<p class="text-gray-400 text-center w-full">No payout types available</p>';
                banksContainer.innerHTML = '<p class="text-gray-400 text-center col-span-full">No banks available for this country</p>';
                return false;
            }
        } catch (error) {
            console.error('Error fetching payout types:', error);
            return false;
        }
    }

    // Render payout type buttons
    function renderPayoutTypes(types) {
        payoutTypesContainer.innerHTML = '';
        
        types.forEach(type => {
            const button = document.createElement('button');
            button.className = 'px-8 py-4 bg-transparent text-white font-bold rounded-lg hover:bg-gray-700/50 transition text-center min-w-[140px] border-b-4 border-transparent';
            button.textContent = formatPayoutType(type);
            button.dataset.type = type;
            
            button.addEventListener('click', () => {
                selectPayoutType(type, button);
            });
            
            payoutTypesContainer.appendChild(button);
        });
    }

    // Format payout type for display
    function formatPayoutType(type) {
        const parts = type.split(' ');
        return parts.join('\n');
    }

    // Select a payout type
    function selectPayoutType(type, button) {
        selectedPayoutType = type;
        
        // Update button styles
        document.querySelectorAll('#payout-types-container button').forEach(btn => {
            btn.classList.remove('bg-cyan-600/30', 'border-b-cyan-400');
            btn.classList.add('bg-transparent', 'border-b-transparent');
        });
        
        button.classList.remove('bg-transparent', 'border-b-transparent');
        button.classList.add('bg-cyan-600/30', 'border-b-cyan-400');
        
        // Load banks for this country and payout type
        loadBanks(selectedCountry, type);
    }

    // Load banks for selected country and payout type
    async function loadBanks(country, payoutType) {
        try {
            const response = await fetch(`/api/banks?country=${encodeURIComponent(country)}&payout_type=${encodeURIComponent(payoutType)}`);
            const data = await response.json();
            
            if (data.success && data.data.length > 0) {
                renderBanks(data.data);
            } else {
                banksContainer.innerHTML = '<p class="text-gray-400 text-center col-span-full">No banks available for this selection</p>';
            }
        } catch (error) {
            console.error('Error fetching banks:', error);
            banksContainer.innerHTML = '<p class="text-red-400 text-center col-span-full">Error loading banks</p>';
        }
    }

    // Render banks grid
    function renderBanks(banks) {
        banksContainer.innerHTML = '';
        
        if (banks.length === 0) {
            banksContainer.innerHTML = '<p class="text-gray-400 text-center col-span-full">No banks available</p>';
            return;
        }
        
        banks.forEach(bank => {
            const bankCard = document.createElement('div');
            bankCard.className = 'partner-logo h-20 rounded-lg flex items-center justify-center p-4 bg-[#1B274B] border border-gray-700 hover:border-cyan-400 hover:bg-[#2a3d63] transition cursor-pointer';
            
            const bankName = document.createElement('span');
            bankName.className = 'text-white text-center text-sm font-medium';
            bankName.textContent = bank.bank_name;
            
            bankCard.appendChild(bankName);
            banksContainer.appendChild(bankCard);
        });
    }

    // Close dropdown when clicking outside
    document.addEventListener('click', (e) => {
        if (!e.target.closest('#country-search') && !e.target.closest('#country-dropdown')) {
            countryDropdown.classList.add('hidden');
        }
    });
</script>

    <!-- Call to Action Section -->
    <?php echo $__env->make('components.cta-section', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Main Footer -->
    <?php echo $__env->make('components.shared-footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/kgolofelo/Downloads/homeremitt_site/resources/views/send-money.blade.php ENDPATH**/ ?>