<?php $__env->startSection('title', 'Help Center - Home Remitt'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .hero-section {
        background-color: #FFFCF6;
        color: #000;
    }
    .search-input {
        background-color: #FFFFFF;
        border: 2px solid #E5E5E5;
    }
    .faq-section {
        background-color: #FFFFFF;
    }
    .faq-item {
        background-color: #FFFFFF;
        border: 1px solid #E5E5E5;
        transition: all 0.2s ease;
    }
    .faq-item:hover {
        background-color: #FFFBF8;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
    }
    .category-button {
        color: rgb(75, 85, 99);
        background-color: transparent;
    }
    .category-button.active {
        background-color: #E5E7EB;
        color: #00B5C5;
    }
    .category-button:hover {
        background-color: transparent;
    }
    .faq-item h3 {
        color: #000;
    }
    .faq-item .answer {
        color: #666;
    }
    .category-title {
        color: #666;
    }
    /* Black hamburger menu for this page */
    .hamburger span {
        background-color: #000000 !important;
    }
    .hero-image-mobile {
        position: absolute;
        bottom: 0;
        right: 0;
        width: 100%;
        max-width: 300px;
        opacity: 0.6;
        z-index: 0;
    }
    .hero-content {
        position: relative;
        z-index: 1;
    }
    .text-gradient-cyan {
        background: linear-gradient(90deg, #0d8fa3 0%, #0d8fa3 50%, #000000 100%);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<!-- Hero & Search -->
<section class="hero-section pt-16 pb-12 lg:pb-20 relative overflow-hidden">
    <div class="container mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
        <!-- Mobile Background Image -->
        <div class="lg:hidden absolute bottom-0 w-full max-w-xs opacity-60" style="top: 30%; right: -5%; transform: translateY(-50%);">
            <img src="<?php echo e(asset('images/aboutus2.png')); ?>" alt="Help and support" class="w-full h-auto object-contain">
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <!-- Left Content -->
            <div class="text-center lg:text-left lg:pr-8 hero-content">
                <h1 class="text-4xl lg:text-5xl mb-6 text-gray-900">How can we help you?</h1>
                <p class="text-lg text-gray-700 mb-8 leading-relaxed">
                    Home Remitt is a service that allows you to send remittance from South Africa to countries all over the world. It is affordable, efficient and secure.
                </p>
                
                <!-- Search Bar -->
                <div class="relative max-w-lg mx-auto lg:mx-0">
                    <input type="text" placeholder="Search for answers..." class="search-input w-full py-4 pl-12 pr-4 rounded-full text-gray-900 placeholder-gray-500 focus:outline-none focus:border-cyan-500 transition shadow-md">
                    <i class="fas fa-search absolute left-5 top-1/2 transform -translate-y-1/2 text-gray-500"></i>
                </div>
            </div>

            <!-- Right Image -->
            <div class="hidden lg:block">
                <img src="<?php echo e(asset('images/aboutus2.png')); ?>" alt="Help and support" class="w-full h-auto object-contain">
            </div>
        </div>
    </div>
</section>

<!-- Questions Section -->
<section class="py-16 lg:py-20 bg-white">
    <div class="container mx-auto max-w-7xl px-4 sm:px-6 lg:px-8 text-left">
        <p class="text-sm font-semibold uppercase tracking-wide mb-2" style="color: #072538;">Any Question?</p>
        <h2 class="text-3xl lg:text-4xl font-bold mb-6 text-gradient-cyan">Frequently Asked Questions</h2>
        <p class="text-lg text-gray-600">Still you have any questions? Contact our Team via hello@homeremitt.com</p>
    </div>
</section>

<!-- FAQ Section -->
<section class="faq-section -mt-8 lg:-mt-12 py-0 lg:py-2">
    <div class="container mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
        
        <div class="grid grid-cols-1 lg:grid-cols-4 gap-8 lg:gap-12">
            <!-- Sidebar / Categories -->
            <div class="lg:col-span-1">
                <div class="flex lg:flex-col gap-2 overflow-x-auto lg:overflow-x-visible">
                    <button class="category-button active px-4 py-3 rounded-lg font-medium transition whitespace-nowrap lg:whitespace-normal lg:w-full text-left">General</button>
                    <button class="category-button px-4 py-3 rounded-lg font-medium transition whitespace-nowrap lg:whitespace-normal lg:w-full text-left">Send Money</button>
                    <button class="category-button px-4 py-3 rounded-lg font-medium transition whitespace-nowrap lg:whitespace-normal lg:w-full text-left">Transaction</button>
                    <button class="category-button px-4 py-3 rounded-lg font-medium transition whitespace-nowrap lg:whitespace-normal lg:w-full text-left">Company</button>
                </div>
            </div>

            <!-- FAQ List -->
            <div class="lg:col-span-3 space-y-3">
                <!-- Question 1 -->
                <div class="bg-gray-50 rounded-lg p-6 cursor-pointer hover:bg-gray-100 transition border border-gray-200 faq-item" onclick="this.querySelector('.answer').classList.toggle('hidden'); this.querySelector('.faq-icon').textContent = this.querySelector('.answer').classList.contains('hidden') ? '+' : '−';">
                    <div class="flex justify-between items-center">
                        <h3 class="font-medium" style="color: #072538; font-family: 'Red Hat Display', sans-serif; font-size: 16px;">Who is Home Remitt?</h3>
                        <span class="text-2xl text-gray-400 faq-icon">−</span>
                    </div>
                    <div class="answer mt-3 text-sm leading-relaxed" style="color: #434343; font-family: 'Red Hat Display', sans-serif; font-size: 14px;">
                        We are a technology-enabled, fully regulated money transfer service that allows individuals to send money to various international countries efficiently and securely.
                    </div>
                </div>

                <!-- Question 2 -->
                <div class="bg-gray-50 rounded-lg p-6 cursor-pointer hover:bg-gray-100 transition border border-gray-200 faq-item" onclick="this.querySelector('.answer').classList.toggle('hidden'); this.querySelector('.faq-icon').textContent = this.querySelector('.answer').classList.contains('hidden') ? '+' : '−';">
                    <div class="flex justify-between items-center">
                        <h3 class="font-medium" style="color: #072538; font-family: 'Red Hat Display', sans-serif; font-size: 16px;">Is Home Remitt regulated?</h3>
                        <span class="text-2xl text-gray-400 faq-icon">+</span>
                    </div>
                    <div class="answer hidden mt-3 text-sm leading-relaxed" style="color: #434343; font-family: 'Red Hat Display', sans-serif; font-size: 14px;">
                        Yes, Home Remitt is fully regulated by the South African Reserve Bank and complies with all financial intelligence regulations.
                    </div>
                </div>

                <!-- Question 3 -->
                <div class="bg-gray-50 rounded-lg p-6 cursor-pointer hover:bg-gray-100 transition border border-gray-200 faq-item" onclick="this.querySelector('.answer').classList.toggle('hidden'); this.querySelector('.faq-icon').textContent = this.querySelector('.answer').classList.contains('hidden') ? '+' : '−';">
                    <div class="flex justify-between items-center">
                        <h3 class="font-medium" style="color: #072538; font-family: 'Red Hat Display', sans-serif; font-size: 16px;">Why should I join the Home Remitt family?</h3>
                        <span class="text-2xl text-gray-400 faq-icon">+</span>
                    </div>
                    <div class="answer hidden mt-3 text-sm leading-relaxed" style="color: #434343; font-family: 'Red Hat Display', sans-serif; font-size: 14px;">
                        We offer competitive rates, low fees, and a secure platform that ensures your money reaches your loved ones safely and quickly.
                    </div>
                </div>

                <!-- Question 4 -->
                <div class="bg-gray-50 rounded-lg p-6 cursor-pointer hover:bg-gray-100 transition border border-gray-200 faq-item" onclick="this.querySelector('.answer').classList.toggle('hidden'); this.querySelector('.faq-icon').textContent = this.querySelector('.answer').classList.contains('hidden') ? '+' : '−';">
                    <div class="flex justify-between items-center">
                        <h3 class="font-medium" style="color: #072538; font-family: 'Red Hat Display', sans-serif; font-size: 16px;">Where is Home Remitt based?</h3>
                        <span class="text-2xl text-gray-400 faq-icon">+</span>
                    </div>
                    <div class="answer hidden mt-3 text-sm leading-relaxed" style="color: #434343; font-family: 'Red Hat Display', sans-serif; font-size: 14px;">
                        We are based in South Africa, with our headquarters in Johannesburg.
                    </div>
                </div>

                 <!-- Question 5 -->
                 <div class="bg-gray-50 rounded-lg p-6 cursor-pointer hover:bg-gray-100 transition border border-gray-200 faq-item" onclick="this.querySelector('.answer').classList.toggle('hidden'); this.querySelector('.faq-icon').textContent = this.querySelector('.answer').classList.contains('hidden') ? '+' : '−';">
                    <div class="flex justify-between items-center">
                        <h3 class="font-medium" style="color: #072538; font-family: 'Red Hat Display', sans-serif; font-size: 16px;">How do I contact Home Remitt for assistance?</h3>
                        <span class="text-2xl text-gray-400 faq-icon">+</span>
                    </div>
                    <div class="answer hidden mt-3 text-sm leading-relaxed" style="color: #434343; font-family: 'Red Hat Display', sans-serif; font-size: 14px;">
                        You can contact us via our Contact Us page, WhatsApp support at 064 303 0300, or through our help center.
                    </div>
                </div>

                <!-- Question 6 -->
                <div class="bg-gray-50 rounded-lg p-6 cursor-pointer hover:bg-gray-100 transition border border-gray-200 faq-item" onclick="this.querySelector('.answer').classList.toggle('hidden'); this.querySelector('.faq-icon').textContent = this.querySelector('.answer').classList.contains('hidden') ? '+' : '−';">
                    <div class="flex justify-between items-center">
                        <h3 class="font-medium" style="color: #072538; font-family: 'Red Hat Display', sans-serif; font-size: 16px;">What do I need to join the Home Remitt family?</h3>
                        <span class="text-2xl text-gray-400 faq-icon">+</span>
                    </div>
                    <div class="answer hidden mt-3 text-sm leading-relaxed" style="color: #434343; font-family: 'Red Hat Display', sans-serif; font-size: 14px;">
                        You need a valid South African mobile number and basic personal information to get started with Home Remitt.
                    </div>
                </div>

                <!-- Question 7 -->
                <div class="bg-gray-50 rounded-lg p-6 cursor-pointer hover:bg-gray-100 transition border border-gray-200 faq-item" onclick="this.querySelector('.answer').classList.toggle('hidden'); this.querySelector('.faq-icon').textContent = this.querySelector('.answer').classList.contains('hidden') ? '+' : '−';">
                    <div class="flex justify-between items-center">
                        <h3 class="font-medium" style="color: #072538; font-family: 'Red Hat Display', sans-serif; font-size: 16px;">How much can I send and to how many Home Remitt family?</h3>
                        <span class="text-2xl text-gray-400 faq-icon">+</span>
                    </div>
                    <div class="answer hidden mt-3 text-sm leading-relaxed" style="color: #434343; font-family: 'Red Hat Display', sans-serif; font-size: 14px;">
                        The amount you can send varies depending on your account status and the destination country. You can send to multiple beneficiaries without limit.
                    </div>
                </div>

                <!-- Question 8 -->
                <div class="bg-gray-50 rounded-lg p-6 cursor-pointer hover:bg-gray-100 transition border border-gray-200 faq-item" onclick="this.querySelector('.answer').classList.toggle('hidden'); this.querySelector('.faq-icon').textContent = this.querySelector('.answer').classList.contains('hidden') ? '+' : '−';">
                    <div class="flex justify-between items-center">
                        <h3 class="font-medium" style="color: #072538; font-family: 'Red Hat Display', sans-serif; font-size: 16px;">What are Home Remitt's transaction fees?</h3>
                        <span class="text-2xl text-gray-400 faq-icon">+</span>
                    </div>
                    <div class="answer hidden mt-3 text-sm leading-relaxed" style="color: #434343; font-family: 'Red Hat Display', sans-serif; font-size: 14px;">
                        Our transaction fees are competitive and vary based on the destination country and payout method. Visit our fees page for detailed pricing.
                    </div>
                </div>

                <!-- Question 9 -->
                <div class="bg-gray-50 rounded-lg p-6 cursor-pointer hover:bg-gray-100 transition border border-gray-200 faq-item" onclick="this.querySelector('.answer').classList.toggle('hidden'); this.querySelector('.faq-icon').textContent = this.querySelector('.answer').classList.contains('hidden') ? '+' : '−';">
                    <div class="flex justify-between items-center">
                        <h3 class="font-medium" style="color: #072538; font-family: 'Red Hat Display', sans-serif; font-size: 16px;">Which countries can I send money to?</h3>
                        <span class="text-2xl text-gray-400 faq-icon">+</span>
                    </div>
                    <div class="answer hidden mt-3 text-sm leading-relaxed" style="color: #434343; font-family: 'Red Hat Display', sans-serif; font-size: 14px;">
                        Home Remitt supports transfers to multiple countries across Africa, Asia, Europe, and other regions. Check our app or website for the full list of supported destinations.
                    </div>
                </div>

                <!-- Question 10 -->
                <div class="bg-gray-50 rounded-lg p-6 cursor-pointer hover:bg-gray-100 transition border border-gray-200 faq-item" onclick="this.querySelector('.answer').classList.toggle('hidden'); this.querySelector('.faq-icon').textContent = this.querySelector('.answer').classList.contains('hidden') ? '+' : '−';">
                    <div class="flex justify-between items-center">
                        <h3 class="font-medium" style="color: #072538; font-family: 'Red Hat Display', sans-serif; font-size: 16px;">How do I create a transaction?</h3>
                        <span class="text-2xl text-gray-400 faq-icon">+</span>
                    </div>
                    <div class="answer hidden mt-3 text-sm leading-relaxed" style="color: #434343; font-family: 'Red Hat Display', sans-serif; font-size: 14px;">
                        Creating a transaction is simple: choose your beneficiary, select the amount and payout method, and confirm. You can do this through our mobile app or website.
                    </div>
                </div>

                <!-- Question 11 -->
                <div class="bg-gray-50 rounded-lg p-6 cursor-pointer hover:bg-gray-100 transition border border-gray-200 faq-item" onclick="this.querySelector('.answer').classList.toggle('hidden'); this.querySelector('.faq-icon').textContent = this.querySelector('.answer').classList.contains('hidden') ? '+' : '−';">
                    <div class="flex justify-between items-center">
                        <h3 class="font-medium" style="color: #072538; font-family: 'Red Hat Display', sans-serif; font-size: 16px;">How can my beneficiary receive money?</h3>
                        <span class="text-2xl text-gray-400 faq-icon">+</span>
                    </div>
                    <div class="answer hidden mt-3 text-sm leading-relaxed" style="color: #434343; font-family: 'Red Hat Display', sans-serif; font-size: 14px;">
                        Your beneficiary can receive money through bank transfer, cash pickup at partner locations, or mobile money, depending on the destination country.
                    </div>
                </div>

                <!-- Question 12 -->
                <div class="bg-gray-50 rounded-lg p-6 cursor-pointer hover:bg-gray-100 transition border border-gray-200 faq-item" onclick="this.querySelector('.answer').classList.toggle('hidden'); this.querySelector('.faq-icon').textContent = this.querySelector('.answer').classList.contains('hidden') ? '+' : '−';">
                    <div class="flex justify-between items-center">
                        <h3 class="font-medium" style="color: #072538; font-family: 'Red Hat Display', sans-serif; font-size: 16px;">How long does it take for the money to reach my beneficiary?</h3>
                        <span class="text-2xl text-gray-400 faq-icon">+</span>
                    </div>
                    <div class="answer hidden mt-3 text-sm leading-relaxed" style="color: #434343; font-family: 'Red Hat Display', sans-serif; font-size: 14px;">
                        Most transfers are completed within minutes to a few hours, depending on the destination country and payout method selected.
                    </div>
                </div>

                <!-- Question 13 -->
                <div class="bg-gray-50 rounded-lg p-6 cursor-pointer hover:bg-gray-100 transition border border-gray-200 faq-item" onclick="this.querySelector('.answer').classList.toggle('hidden'); this.querySelector('.faq-icon').textContent = this.querySelector('.answer').classList.contains('hidden') ? '+' : '−';">
                    <div class="flex justify-between items-center">
                        <h3 class="font-medium" style="color: #072538; font-family: 'Red Hat Display', sans-serif; font-size: 16px;">Tell me about Home Remitt's fees and exchange rates?</h3>
                        <span class="text-2xl text-gray-400 faq-icon">+</span>
                    </div>
                    <div class="answer hidden mt-3 text-sm leading-relaxed" style="color: #434343; font-family: 'Red Hat Display', sans-serif; font-size: 14px;">
                        We offer competitive exchange rates and transparent fees. Our rates are updated in real-time to give you the best value for your money.
                    </div>
                </div>

                <!-- Question 14 -->
                <div class="bg-gray-50 rounded-lg p-6 cursor-pointer hover:bg-gray-100 transition border border-gray-200 faq-item" onclick="this.querySelector('.answer').classList.toggle('hidden'); this.querySelector('.faq-icon').textContent = this.querySelector('.answer').classList.contains('hidden') ? '+' : '−';">
                    <div class="flex justify-between items-center">
                        <h3 class="font-medium" style="color: #072538; font-family: 'Red Hat Display', sans-serif; font-size: 16px;">Do you have anyone near me who can assist?</h3>
                        <span class="text-2xl text-gray-400 faq-icon">+</span>
                    </div>
                    <div class="answer hidden mt-3 text-sm leading-relaxed" style="color: #434343; font-family: 'Red Hat Display', sans-serif; font-size: 14px;">
                        We have pay-in points across South Africa. Use our locator feature on the app to find the nearest location to you.
                    </div>
                </div>

                <!-- Question 15 -->
                <div class="bg-gray-50 rounded-lg p-6 cursor-pointer hover:bg-gray-100 transition border border-gray-200 faq-item" onclick="this.querySelector('.answer').classList.toggle('hidden'); this.querySelector('.faq-icon').textContent = this.querySelector('.answer').classList.contains('hidden') ? '+' : '−';">
                    <div class="flex justify-between items-center">
                        <h3 class="font-medium" style="color: #072538; font-family: 'Red Hat Display', sans-serif; font-size: 16px;">How can I join the Home Remitt family?</h3>
                        <span class="text-2xl text-gray-400 faq-icon">+</span>
                    </div>
                    <div class="answer hidden mt-3 text-sm leading-relaxed" style="color: #434343; font-family: 'Red Hat Display', sans-serif; font-size: 14px;">
                        Download our mobile app from the Google Play Store, Apple App Store, or Huawei AppGallery, then follow the simple registration process to get started.
                    </div>
                </div>

            </div>
        </div>
    </div>
</section>

<!-- CTA Component -->
<?php echo $__env->make('components.cta-section', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<!-- Footer Component -->
<?php echo $__env->make('components.shared-footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/kgolofelo/Downloads/homeremitt_site/resources/views/help.blade.php ENDPATH**/ ?>